///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _ROUTINES_H
#define _ROUTINES_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <SQL.H>

#include "../../SharedSource/Debug.H"

#include "../../SharedClasses/NASCCL/NASCCL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/CMemPool/CMemPool.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define CRYPTKEY        "XHU7wSIv8f3h5tpmx6G1kCubtpFegXhO"
#define CRYPTFLAGS      ROUNDRESULT | NONREPETITION | ENSUREOFFSET
#define MAX_STATUS_TEXT 10240
#define SENDBUFSZ       4096
#define RECVBUFSZ       5120

#define MAX_AUTH_LENGTH 1024 //Max size of the string used for authentication
#define MAX_KEY_LENGTH  1024 //Max size of the encryption key. (Both Registry & Generated)

#define FILEBUFFERSZ    4000

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SaveRegistryValues(void);
bool GetRegistryValues(void);
bool WaitOnApplicationToExit(void);
bool ConnectToServer(void);
bool IsClientConfigured(bool bAlertUser);
bool LaunchConfigDlg(HWND hOwner);

void SetStatus(HWND hGrid, int iCol, int iItem, char *sText);
bool IsAtleastOneDaySelected(void);
int GetNextRunDay(int iToday);
void UpdateStatistics(void);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern NASCCL gSC;

struct _MainDialogInfo{
	HWND hLogList;
	HWND hStatusBar;
	HMENU hMenu;
}; extern _MainDialogInfo MDI;

struct _ConnectedClientInfo{
	int iThisClient;
	int iInitStep;

	DWORD dwCompressionLevel;

	bool bIsAuthenticated;
	bool bIsEncryptionInit;
	bool bCustDBConnected;
	bool bUseCompression;

	NASCCL SC;

	char sCompressionMethod[255];
	
	char sTransDatabase[255];
	char sTransTable[255];
	char sTransDBO[255];

	char sOnSuccess[2048 + 1];
	char sOnFailure[2048 + 1];

    HSTMT hStatementHandle;

	CSQL cCustSQL;
	CRecordSet rsTrans;

}; extern _ConnectedClientInfo CCI;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern CRITICAL_SECTION csTransPerSecond;

DWORD WINAPI Timer_Thread(LPVOID);

extern const char *gsWeekDayName[];

extern bool gbWeekDays[7];

extern char gsSessionLogDir[MAX_PATH];
extern char sTempFilesPath[MAX_PATH];
extern char gsPath[MAX_PATH];
extern char gsServerAddress[255];
extern char gsAuthKey[MAX_AUTH_LENGTH];
extern char gsAuthString[MAX_AUTH_LENGTH];
extern char gsGUIPWDHash[256];
extern char gsDBMode[255];

extern char gsCompanyName[64];
extern char gsCompanyPassword[64];

extern char gsSQLDataFiles[MAX_PATH]; // Relative to server.
extern char gsDefaultDBO[255];
extern char gsReplicationDB[255];

extern char gsSQLDriver[255];
extern char gsSQLPassword[255];
extern char gsSQLServer[255];
extern char gsSQLUserID[255];

extern bool gbShowSplashScreen;
extern bool gbKillApplication;
extern bool gbApplicationRunning;
extern bool gbConnectNow;
extern bool gbRunningAsService;
extern bool gbThrowSQLErrors;
extern bool gbReplaceSngleQteSQLData;
extern bool gbRTrimSQLData;
extern bool gbDropBadPackets;
extern bool gbPacketMode;
extern bool gbAutoConnect;
extern bool gbCacheLogFile;
extern bool gbIsMainDialogOpen;
extern bool gbDebugMode;
extern bool gbExcludeInit;

extern int giNextDay;			 // The day on which the next connection will occur.
extern int giTransProcessed;

extern DWORD gdwConnectInterval; // The interval on which each connection will occur.
extern DWORD gdwErrorCount;
extern DWORD gdwMaxClients;
extern DWORD gdwNextTime;		 // The time at which the next connection will occur.
extern DWORD gdwPingTimeoutMS;
extern DWORD gdwServerPort;
extern DWORD gdwStartTime;		 // The beginning of the connection time window.
extern DWORD gdwStopTime;		 // The End of the connection time window.
extern DWORD gdwTotalConnects;
extern DWORD gdwWarningCount;
extern DWORD Timer_Thread_ID;
extern DWORD gdwGUIPWHashSz;

extern HANDLE Timer_Thread_Handle;

extern FILE *gfhSessionLog;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
